@extends('layouts.default')
@section('conteudo')
    <h3>
        Cadastrar Pagamento
        <a href="{{url('financeiro')}}" class="material-icons float-right" style="font-size: 1.3em; color: #333;">
            keyboard_backspace
        </a>  
    </h3>
    <hr>

    @if (session('sucesso'))
        <div class="alert alert-success">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        {!! session('sucesso') !!}
        </div>
    @endif

    @if($emAtraso)
        <div class="alert alert-danger">
            <strong>Alerta!</strong> Mensalidade em atraso a <b>{{$diasEmAtraso}} dias</b>. Vencimento em <b>{{$proximaDataAPagar}}</b>
        </div>
    @endif

    <form id="formulario" method="post" action="{{ url('financeiro/store') }}" autocomplete="off" onsubmit="aguarde(this)">
        {{ @csrf_field() }}

        <input type="hidden" name="id" value="">

        <div class="row">
            <div class="col-md-7">
                <div class="form-group">
                    <div><label>Cliente</label></div>
                    <select name="cliente" id="cliente" class="form-control" required onchange="cobrancas()">
                        <option value="">SELECIONE...</option>
                        @foreach($clientes as $v)
                            <option {{ ($cliente==$v->id) ? 'selected' : '' }} value="{{ $v->id }}">{{ $v->nome }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="form-group">
                    <div><label>Mês</label></div>
                    <select name="mes" id="mes" class="form-control" required onchange="cobrancas()">
                        <option value="">Todos...</option>
                        @foreach($meses as $i => $mes)
                            <option {{ ($mesSelec == $i ? 'selected' : '') }} value="{{ $i }}">{{ $mes }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <div><label>Ano</label></div>
                    <select name="ano" id="ano" class="form-control" required onchange="cobrancas()">
                        @foreach($anoRef as $ano)
                            <option {{ ($anoSelec==$ano || date('Y')==$ano) ? 'selected' : '' }} value="{{ $ano }}">{{ $ano }}</option>
                        @endforeach
                    </select>
                </div>
            </div>            
        </div>
    </form>

    <br />

    <h3>
        Histórico de Pagamentos do Cliente

        @if($cliente)
            <a href="{{url('financeiro/create/'.$cliente)}}" id="btnSalvar" class="btn btn-primary float-right btn">+ Novo Pagamento</a>
        @endif
    </h3>

    <table class="table table-hover" width="100%">
        <thead>
            <tr style="background: {{ config('parque.btn-parque') }}; color: white;">
                <th>&nbsp;</th>
                <th class="text-center">Referência</th>
                <th class="text-center">Dependentes</th>
                <th class="text-center">Forma Pag</th>
                <th class="text-center">Vencimento</th>
                <th class="text-center">Pago em</th>
                <th class="text-center">Cobrado</th>
                <th class="text-center">Pago</th>
            </tr>
        </thead>

        <?php $valorTotal = 0; ?>

        @if($cliente && $cobrancas->count())
            @foreach($cobrancas as $pag)
                <tr>
                    <td align="center">
                        <a href="{{url('financeiro/edit/'.$pag->id)}}"><i class="material-icons icone">edit</i></a>
                    </td>
                    <td align="center"><div class="badge badge-success" style="font-size: 12px;">{{$pag->mes_ref}}/{{$pag->ano_ref}}</div></td>
                    <td align="center">{{$pag->dependentes}}</td>
                    <td align="center">{{$pag->forma_pagamento}}</td>
                    <td align="center">{{date('d/m/Y', strtotime($pag->dt_vencimento))}}</td>
                    <td align="center">{{date('d/m/Y', strtotime($pag->dt_pagamento))}}</td>
                    <td align="center">{{number_format($pag->valor_total_cobranca, 2, ',', '.')}}</td>
                    <td align="center">{{number_format($pag->valor_pago, 2, ',', '.')}}</td>
                </tr>

                <?php $valorTotal += $pag->valor_pago; ?>

            @endforeach
        @else
            <tr>
                <td colspan="8" align="center">
                    @if(!$cliente)
                        Selecione um cliente para ver o seu histórico de pagamento.
                    @else
                        Nenhum registro de pagamento encontrado.
                    @endif
                </td>
            </tr>
        @endif

        <tr>
            <th colspan="8" class="text-right h5">Total R$ {{number_format($valorTotal, 2, ',', '.')}}</th>
        </tr>

    </table>

@endsection

@section('scripts')
<script>
    var cliente = document.getElementById('cliente');
    var ano     = document.getElementById('ano');
    var mes     = document.getElementById('mes');

    function cobrancas() {
        window.location = BASE_URL+'financeiro/historico?cliente='+cliente.value+'&ano='+ano.value+'&mes='+mes.value;
    }

</script>
@endsection
